/*

  PGP DLL 2.6.3i

  DLL-Anpassung fr PGP-Quellen

  (C) 1997 Jens von Pilgrim

*/

#ifndef _PGPDLL_H_
#define _PGPDLL_H_




#include "WINDOWS.H"
#include <stdio.h>



#ifdef _BUILD_DLL_
  #undef _PGP_DECL_
  #pragma message ("Build DLL (dllexport)")
  #define _PGP_DECL_ _declspec (dllexport)
#else
  #undef _PGP_DECL_
  #pragma message ("Build DLL (dllimport)")	
  #define _PGP_DECL_ _declspec (dllimport) 
#endif

typedef int (*outputFunction) ( FILE*, const char *);
typedef int (*inputFunction) ( const char* msg,  char *strbuf, unsigned maxlen, int echo);
typedef void (*rndaccFunction) (unsigned count);
typedef int (*pagerFunction) ( char *fileName );
typedef int (*phreadFunction)  ( void *buffer, size_t size, size_t count, FILE *stream );
typedef int (*phwriteFunction) ( const void *buffer, size_t size, size_t count, FILE *stream );

typedef struct _pgpparameter
{
	inputFunction inFct;
	outputFunction outFct;
	rndaccFunction rndaccFct;
	pagerFunction pagerFct;
	phreadFunction phreadFct;
    	phwriteFunction phwriteFct;
	const char * lpszArguments;
	
} pgpparameter;



_PGP_DECL_ DWORD WINAPI CALLPGP( LPVOID lpThreadParm );



_PGP_DECL_ const char* WINAPI GETLANG(char* text); 

_PGP_DECL_ const char* WINAPI GETLASTMSG();

_PGP_DECL_ int WINAPI CONTAINS_YESNO();
_PGP_DECL_ int WINAPI CONTAINS_ENOUGH();
_PGP_DECL_ int WINAPI CONTAINS_BADPASS();

_PGP_DECL_ unsigned WINAPI RANDEVENT(int event);

#endif


